/**
 * This file consists of generic tool to help with common functionality in testing
 * across all the specs in this folder.
 */
define([
    'underscore',
    'jquery',
    'backbone',
    'User',
    'App',
    'modules/new-appointment-request/tests/helpers/mock-data-helper',
    'Layout',
], function(_, $, Backbone, user, app, data, Layout) {
    'use strict';


    /**
     * Create a clean state for the view. Make sure that there nothing left over
     * from other test that can confuse the results
     * @return {*} The Testing Region
     */
    function setupTestingRegion() {
        var layout = new Layout();
        return layout.getRegion('content');
    }


    /**
     * Cleaning up after myself so my test don't mess with other peoples tests
     * @return {void}
     */
    function resetTestingRegion() {
        // TODO deleted
    }

    /**
     * Returns the disabled features
     * @returns {*}
     */
    function getDisabledFeatures() {
        if (!_.isUndefined(app.disabledFeatures)) {
            return app.disabledFeatures;
        }
        return null;
    }

    /**
     * Blocks Backbone.Collection.fetch and mocks it with a function that performs the same
     * things without actually making a call over the network
     * @param {array} [mockResponse] Preferably the results of getMockClinicList
     * @return {function} The prototype of the spy.
     */
    function collectionFetchSpy(mockResponse) {
        spyOn(Backbone.Collection.prototype, 'fetch').and.callFake(function(options) {
            var deferred = new $.Deferred();
            deferred.resolveWith(mockResponse);
            if (mockResponse) {
                this.set(mockResponse, {parse: true});
                this.trigger('fetch:success', this, mockResponse, options);
            }
            return deferred;
        });
        return Backbone.Collection.prototype.fetch;
    }


    /**
     * Blocks Backbone.Collection.fetch and mocks it with a function that performs the same
     * things without actually making a call over the network
     * @param {array} mockResponse Preferably the results of getMockClinicList
     * @return {function} The prototype of the spy.
     */
    function modelFetchSpy(mockResponse) {
        spyOn(Backbone.Model.prototype, 'fetch').and.callFake(function(options) {
            var deferred = new $.Deferred();
            deferred.resolveWith(mockResponse);
            if (mockResponse) {
                this.set(mockResponse, {parse: true});
                this.trigger('fetch:success', this, mockResponse, options);
            }
            return deferred;
        });
        return Backbone.Model.prototype.fetch;
    }


    /**
     * Ensures user data needed exists for the test
     * @return {*} The user spy
     */
    function userSpy() {
        var model = new Backbone.Model({
            idType: 'ICN',
            id: '123',
        });

        spyOn(user, 'get').and.callFake(function(key) {
            return model.get(key);
        });

        return user.get;
    }

    function cleanString(str) {
        return str.replace(/\s{2,}|\n/g, ' ').trim();
    }

    return _.extend({}, {
        _: _,
        getDisabledFeatures: getDisabledFeatures,
        setupTestingRegion: setupTestingRegion,
        resetTestingRegion: resetTestingRegion,
        collectionFetchSpy: collectionFetchSpy,
        modelFetchSpy: modelFetchSpy,
        userSpy: userSpy,
        cleanString: cleanString,
    }, data);
});
